%define dbus_version 1.1
%define libgudev_version 232

%define soname 0

%def_enable qrtr
%def_enable qmi
%def_enable mbim
%def_enable introspection
%def_disable vala

Name: ModemManager
Version: 1.24.2
Release: alt1
License: GPLv2+
Group: System/Configuration/Networking
Summary: Mobile broadband modem management service
Url: https://www.freedesktop.org/wiki/Software/ModemManager/
Vcs: https://gitlab.freedesktop.org/mobile-broadband/ModemManager.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: dbus >= %dbus_version

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1
BuildRequires(pre): rpm-macros-systemd >= 6

BuildRequires: libgudev-devel >= %libgudev_version
BuildRequires: libgio-devel
%{?_enable_qrtr:BuildRequires: libqrtr-glib-devel >= 1.0.0}
%{?_enable_qmi:BuildRequires: libqmi-glib-devel >= 1.36.0}
%{?_enable_mbim:BuildRequires: libmbim-glib-devel >= 1.32.0}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools}
BuildRequires: ppp-devel
BuildRequires: libpolkit-devel
BuildRequires: libsystemd-devel >= 209
BuildRequires: libdbus-devel
BuildRequires: gtk-doc bash-completion

# For tests
%{?!_without_check:%{?!_disable_check:BuildRequires: /dev/pts}}
%{?!_without_check:%{?!_disable_check:BuildRequires: dbus}}
%{?!_without_check:%{?!_disable_check:BuildRequires: python3-module-pygobject3 python3-module-dbus}}

# Because of starting from the init script
Conflicts: NetworkManager < 0.9.8.9

%define _unpackaged_files_terminate_build 1

%description
ModemManager provides a DBus interface to communicate with
mobile broadband (GSM, CDMA, UMTS, ...) cards. Implements
a loadable plugin interface to add work-arounds for
non standard devices.

%package devel
License: LGPLv2+
Group: Development/C
Summary: Headers for adding ModemManager support to applications

%description devel
This package contains various headers accessing some ModemManager
functionality from applications.

%package devel-doc
Group: Development/Documentation
Summary: Development documentation for %name
BuildArch: noarch

%description devel-doc
%summary

%package -n libmm-glib
License: LGPLv2+
Summary: Libraries for adding ModemManager support to applications that use glib
Group: System/Libraries

%description -n libmm-glib
This package contains the libraries that make it easier to use some
ModemManager functionality from applications that use glib.

%package -n libmm-glib-devel
License: LGPLv2+
Summary: Development files for libmm-glib
Group: Development/C
Requires: libmm-glib = %version-%release

%description -n libmm-glib-devel
This package contains libraries and header files for
developing applications that use libmm-glib.

%package -n libmm-glib-devel-doc
Group: Development/Documentation
Summary: Development documentation for libmm-glib
BuildArch: noarch

%description -n libmm-glib-devel-doc
%summary

%package -n libmm-glib-gir
Summary: GObject introspection data for the ModemManager
Group: System/Libraries
Requires: libmm-glib = %version-%release

%description -n libmm-glib-gir
%summary

%package -n libmm-glib-gir-devel
Summary: GObject introspection devel data for the ModemManager
Group: System/Libraries
BuildArch: noarch
Requires: libmm-glib-gir = %version-%release
Requires: libmm-glib-devel = %version-%release

%description -n libmm-glib-gir-devel
%summary

%package -n libmm-glib-vala
Summary: Vala bindings for the ModemManager
Group: Development/Other
BuildArch: noarch
Requires: libmm-glib-devel = %version-%release

%description -n libmm-glib-vala
%summary

%prep
%setup -n %name-%version
%patch -p1

%build
%meson \
	-Dudevdir=%_udevdir \
	-Dpolkit=strict \
	-Dsystemdsystemunitdir=%_unitdir \
	-Dsystemd_suspend_resume=true \
	-Dsystemd_journal=true \
	-Dudev=true \
	%{subst_enable_meson_bool qrtr qrtr} \
	%{subst_enable_meson_bool qmi qmi} \
	%{subst_enable_meson_bool mbim mbim} \
	%{subst_enable_meson_bool introspection introspection} \
	%{subst_enable_meson_bool vala vapi} \
	-Dgtk_doc=true

%meson_build -v

%install
%meson_install
%find_lang %name

%check
%meson_test

%post
if sd_booted; then
	%post_service_posttrans_restart %name.service
fi

%preun
# Don't stop service:
# the network can be via modem controlled
# by ModemManager itself.
#preun_service %name
if [ "$1" -eq 0 ]; then
	SYSTEMCTL=systemctl
	if sd_booted && "$SYSTEMCTL" --version >/dev/null 2>&1; then
		"$SYSTEMCTL" --no-reload -q disable %name.service ||:
	fi
fi

%files -f %name.lang
%doc NEWS AUTHORS README.md
%_datadir/dbus-1/system-services/*.service
%_sysconfdir/ModemManager/
%dir %_libdir/ModemManager/
%dir %_libdir/ModemManager/fcc-unlock.d/
%dir %_libdir/ModemManager/connection.d/

%_libdir/ModemManager/*.so
%_sbindir/*
%_bindir/mmcli
%_datadir/%name/
%_datadir/bash-completion/completions/mmcli
%_sysconfdir/dbus-1/system.d/*.conf
%_udev_rulesdir/*
%_iconsdir/hicolor/*/apps/*
%_datadir/polkit-1/actions/*.policy
%_unitdir/*.service
%doc %_man1dir/*.*
%doc %_man8dir/*.*

%files devel
%_includedir/%name
%_pkgconfigdir/%name.pc
%_datadir/dbus-1/interfaces/*.xml

%files devel-doc
%doc %_datadir/gtk-doc/html/%name

%files -n libmm-glib
%_libdir/libmm-glib.so.%soname
%_libdir/libmm-glib.so.%soname.*

%files -n libmm-glib-devel
%_libdir/libmm-glib.so
%_includedir/libmm-glib
%_pkgconfigdir/mm-glib.pc

%files -n libmm-glib-devel-doc
%doc %_datadir/gtk-doc/html/libmm-glib

%if_enabled introspection
%files -n libmm-glib-gir
%_libdir/girepository-1.0/ModemManager-1.0.typelib

%files -n libmm-glib-gir-devel
%_datadir/gir-1.0/ModemManager-1.0.gir
%endif

%if_enabled vala
%files -n libmm-glib-vala
%_datadir/vala/vapi/*
%endif

%changelog
