%define git %nil
%define rname dxcompiler

%ifarch %ix86
%define optflags_lto %nil
%endif

Name: DirectXShaderCompiler
Version: 1.8.2403
Release: alt0.4
Summary: DirectX Shader Compiler
Group: Development/C++
License: Apache-2.0 with LLVM-exception

URL: https://github.com/microsoft/DirectXShaderCompiler
Packager: L.A. Kostis <lakostis@altlinux.org>

Source0: %name-%version.tar
# see https://github.com/microsoft/DirectXShaderCompiler/issues/5079#issuecomment-1480210642
Source1: DirectX-Headers.tar
Patch0: alt-spirv-tools-shared.patch
# https://github.com/microsoft/DirectXShaderCompiler/pull/7240
Patch1: cmake4-support.patch
Patch2000: alt-e2k.patch
Patch3500: alt-loongarch64.patch

ExclusiveArch: %ix86 x86_64 aarch64 %e2k loongarch64

Provides: lib%{rname}-devel = %EVR, lib%{rname} = %EVR
# upstream commit 6d3574a34b7180d75df3a893fe12447c6231a450 removed sonames
Obsoletes: lib%{rname}3

BuildRequires(pre): cmake
BuildRequires: gcc-c++ ninja-build spirv-headers libspirv-tools-devel python3-devel git-core
BuildRequires: directx-headers

%description
The DirectX Shader Compiler project includes a compiler and related tools used
to compile High-Level Shader Language (HLSL) programs into DirectX Intermediate
Language (DXIL) representation. Applications that make use of DirectX for
graphics, games, and computation can use it to generate shader programs.

%prep
%setup -n %name-%version -a1
%patch0 -p1
%patch1 -p1

%ifarch %e2k
%patch2000 -p1
%endif
%patch3500 -p1
cp -aLt autoconf -- /usr/share/automake/config.{guess,sub}

%build
%cmake \
  -GNinja \
  -DCMAKE_BUILD_TYPE=RelWithDebInfo \
  -DCMAKE_C_COMPILER=gcc \
  -DCMAKE_CXX_COMPILER=c++ \
  -DSPIRV-Headers_SOURCE_DIR=%_prefix \
  -DSPIRV_BUILD_TESTS=OFF \
  -C ./cmake/caches/PredefinedParams.cmake
%cmake_build

%install
mkdir -p %buildroot{%_libdir,%_bindir}
cp -ar %_cmake__builddir/lib/lib%{rname}.so* %buildroot%_libdir/
cp -ar %_cmake__builddir/bin/dxc* %buildroot%_bindir/

%files
%_bindir/*
%_libdir/lib%{rname}.so

%changelog
