%def_disable dccm

%define home_dir %_localstatedir/dcc
%define mylibexec_dir %_libexecdir/dcc

# set to spamd because spamassassin is the primary user
%define default_user  spamd
%define default_group spamd

Summary: A clients-server system for collecting checksums of mail messages
Name: DCC
Version: 2.3.169
Release: alt0.1
License: MIT-0
Group: System/Servers
Url: http://www.rhyolite.com/anti-spam/dcc/
Source0: http://www.rhyolite.com/anti-spam/dcc/source/dcc-%version.tar
Source1: dcc.service
Source2: dccifd.socket
Requires: spamassassin-spamd

%if_enabled dccm
BuildRequires: sendmail-devel
%endif

%description
The DCC or Distributed Checksum Clearinghouse is currently a system of
many clients and more than 120 servers that collects and count
checksums related to several million mail messages per day, most as
seen by Internet Service Providers. The counts can be used by SMTP
servers and mail user agents to detect and reject or filter spam or
unsolicited bulk mail. DCC servers exchange or "flood" common
checksums. The checksums include values that are constant across
common variations in bulk messages, including "personalizations."

%prep
%setup -n dcc-%version
find . -name Makefile.in | xargs subst 's/chown/:/g'

%build
export CFLAGS="%optflags"
PERL=%_bindir/perl ./configure \
  --with-installroot=%buildroot \
  %{subst_enable dccm} \
  --homedir=%home_dir \
  --libexecdir=%mylibexec_dir \
  --bindir=%_bindir \
  --mandir=%_mandir \
  --disable-sys-inst
%make_build

%install
make install
#make install \
#  SET_BINOWN= SET_MANOWN= SET_DCCOWN=
%_bindir/perl -pi -e 's,%buildroot,,gi' %buildroot%home_dir/map.txt
mkdir -p %buildroot%_man8dir
cp -a *.8 %buildroot%_man8dir
install -pD -m644 %SOURCE1 %buildroot%_unitdir/dcc.service
install -pD -m644 %SOURCE2 %buildroot%_unitdir/dccifd.socket
mkdir -p %buildroot{%_initdir,%_sysconfdir/cron.daily}
ln -s %mylibexec_dir/rcDCC %buildroot%_initdir/rcDCC
ln -s %mylibexec_dir/cron-dccd %buildroot%_sysconfdir/cron.daily/cron-dcc

%files
%doc LICENSE FAQ* CHANGES
%attr(43770,root,%default_group) %dir %home_dir
%attr(640,root,%default_group) %config(noreplace) %home_dir/dcc_conf
%attr(640,root,%default_group) %config(noreplace) %home_dir/flod
%attr(640,root,%default_group) %config(noreplace) %home_dir/grey_flod
%attr(640,root,%default_group) %config(noreplace) %home_dir/grey_whitelist
%attr(600,%default_user,%default_group) %config(noreplace) %home_dir/ids
%attr(710,%default_user,%default_group) %config(noreplace) %home_dir/log
%attr(600,%default_user,%default_group) %config(noreplace) %home_dir/map
%attr(600,%default_user,%default_group) %config(noreplace) %home_dir/map.txt
%attr(640,root,%default_group) %config(noreplace) %home_dir/whiteclnt
%attr(640,root,%default_group) %config(noreplace) %home_dir/whitecommon
%attr(640,root,%default_group) %config(noreplace) %home_dir/whitelist
%config %_unitdir/dcc.service
%config %_unitdir/*.socket
%_sysconfdir/cron.daily/*
%_initdir/*
%_bindir/cdcc
%_bindir/dccproc
%_bindir/dccif-test
%mylibexec_dir
%_man8dir/*

%changelog
