Name: AlephOne
Version: 1.10
%define uversion 20240822

Release: alt1

Summary: 3D first-person shooter game
License: %gpl2plus
Group: Games/Arcade
Url: https://alephone.lhowon.org
# Url git  https://github.com/Aleph-One-Marathon/alephone

# https://github.com/Aleph-One-Marathon/alephone/releases/download/release-20220115/AlephOne-20220115.tar.bz2

Packager: Hihin Ruslan <ruslandh@altlinux.ru>

Source0: %name-%uversion.tar
Source1: %name.desktop
Source2: %name-48x48.png
Source3: alephone-wrapper.sh

#Patch0: %name-1.0.1-gcc8-fix.patch

BuildRequires(pre): rpm-build-licenses autoconf-archive

#BuildPreReq: libSDL2-devel libSDL2_image-devel libSDL2_net-devel  boost-program_options-devel
#BuildPreReq: libsdl2_sound-devel libSDL2_ttf-devel boost-filesystem-devel


# Automatically added by buildreq on Sun Jan 19 2025
# optimized out: boost-devel boost-devel-headers glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config libSDL2-devel libglvnd-devel libgpg-error libp11-kit libsasl2-3 libstdc++-devel perl pkg-config python3 python3-base sh5 zlib-devel
BuildRequires: boost-filesystem-devel boost-lockfree-devel gcc-c++ libGLU-devel libSDL2_image-devel libSDL2_net-devel libSDL2_ttf-devel
BuildRequires: libcurl-devel libminiupnpc-devel libopenal-devel libpng-devel libsndfile-devel perl-parent python3-dev

#BuildRequires: libmad-devel libsmpeg-devel libspeex-devel libspeexdsp-devel
#BuildRequires: libvorbis-devel lua5.3 python3-dev libopenal-devel zlib-devel   /usr/bin/python3

BuildRequires: desktop-file-utils  autoconf-archive

%description
Aleph One is an Open Source 3D first-person shooter game, based on the game
Marathon 2 by Bungie Software. It is set in a Sci-Fi universe dominated by
deviant computer AIs and features a well thought-out plot. Aleph One
supports, but doesn't require, OpenGL for rendering.

Aleph One requires additional data -- shape, sound, and map
information -- in order to run. The easiest way to get this is to go
to http://source.bungie.org/get/, and download one of the scenario zip
files there. Unzip it, and pass the resulting directory as an argument
to alephone. For example:

alephone "~/Marathon Infinity"

%prep
%setup -n %name-%uversion
#patch0 -p2

%build
#add_optflags -fpermissive
#configure --bindir=%_gamesbindir --datadir=%_gamesdatadir
#make_build

%autoreconf

%add_optflags -fpermissive -Wmisleading-indentation
%configure \
--enable-dependency-tracking

%make_build

%install
%makeinstall_std
#desktop-file-install --dir %buildroot%_desktopdir %SOURCE1
#install -pD -m644 %SOURCE2 %buildroot%_liconsdir/%name.png
#install -pD -m755 %SOURCE3 %buildroot%_gamesbindir/

%files
%doc AUTHORS COPYING README.md docs/README.txt docs/*.html examples
%_bindir/alephone
#%_datadir/AlephOne/Fonts
%_datadir/AlephOne/MML
%_datadir/AlephOne/Plugins
%_datadir/mime/packages/*.xml

%_iconsdir/hicolor/*/mimetypes/*.png

%_man6dir/*

#doc AUTHORS COPYING  INSTALL.Unix README docs/*.html examples
#dir %_gamesdatadir/%name
#dir %_gamesdatadir/%name/MML
#dir %_gamesdatadir/%name/Themes
#_gamesbindir/*
#_gamesdatadir/%name/Fonts
#_gamesdatadir/%name/MML/*.mml
#_gamesdatadir/%name/Themes/Default
#_liconsdir/%name.png
#_desktopdir/*
#_man6dir/*


%changelog
